/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.parameters.RSAPkcsParameters;
import iaik.pkcs.pkcs11.wrapper.CK_RSA_PKCS_OAEP_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class RSAPkcsOaepParameters
extends RSAPkcsParameters {
    protected long source_;
    protected byte[] sourceData_;

    public RSAPkcsOaepParameters(Mechanism mechanism, long l, long l2, byte[] byArray) {
        super(mechanism, l);
        if (l2 != 0L && l2 != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"source\": " + Functions.toHexString(l2));
        }
        this.source_ = l2;
        this.sourceData_ = byArray;
    }

    public Object clone() {
        RSAPkcsOaepParameters rSAPkcsOaepParameters = (RSAPkcsOaepParameters)super.clone();
        rSAPkcsOaepParameters.sourceData_ = (byte[])this.sourceData_.clone();
        return rSAPkcsOaepParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RSAPkcsOaepParameters) {
            RSAPkcsOaepParameters rSAPkcsOaepParameters = (RSAPkcsOaepParameters)object;
            bl = this == rSAPkcsOaepParameters || super.equals(rSAPkcsOaepParameters) && this.source_ == rSAPkcsOaepParameters.source_ && Functions.equals(this.sourceData_, rSAPkcsOaepParameters.sourceData_);
        }
        return bl;
    }

    public Object getPKCS11ParamsObject() {
        CK_RSA_PKCS_OAEP_PARAMS cK_RSA_PKCS_OAEP_PARAMS = new CK_RSA_PKCS_OAEP_PARAMS();
        cK_RSA_PKCS_OAEP_PARAMS.hashAlg = this.hashAlgorithm_.getMechanismCode();
        cK_RSA_PKCS_OAEP_PARAMS.mgf = this.maskGenerationFunction_;
        cK_RSA_PKCS_OAEP_PARAMS.source = this.source_;
        cK_RSA_PKCS_OAEP_PARAMS.pSourceData = this.sourceData_;
        return cK_RSA_PKCS_OAEP_PARAMS;
    }

    public long getSource() {
        return this.source_;
    }

    public byte[] getSourceData() {
        return this.sourceData_;
    }

    public int hashCode() {
        return super.hashCode() ^ (int)this.source_ ^ Functions.hashCode(this.sourceData_);
    }

    public void setSource(long l) {
        if (l != 0L && l != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"source\": " + Functions.toHexString(l));
        }
        this.source_ = l;
    }

    public void setSourceData(byte[] byArray) {
        this.sourceData_ = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Source: ");
        if (this.source_ == 0L) {
            stringBuffer.append("Empty");
        } else if (this.source_ == 1L) {
            stringBuffer.append("Data Specified");
        } else {
            stringBuffer.append("<unknown>");
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Source Data (hex): ");
        stringBuffer.append(Functions.toHexString(this.sourceData_));
        return stringBuffer.toString();
    }

    public static interface SourceType {
        public static final long EMPTY = 0L;
        public static final long DATA_SPECIFIED = 1L;
    }
}

